#!/bin/bash
export datasets="Cora CiteSeer PubMed cs wikics"
export datasets2="OGBN-Arxiv"
export missing_rates="0.99 0.999 0.9999 1.0"
export missing_rates_test="0.1"
export lambda_list="1e-5 1e-4 1e-3 1e-2 1e-1 1e+0 1e+1"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=3

for dataset in $datasets
do
for missing_rate in $missing_rates
do
python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --embedder GOODIE_best --scaled True --gnn GCN --filling_method fp --n_runs 10 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type row --missing_rate ${missing_rate} --embedder GOODIE_best --scaled True --gnn GCN --filling_method fp --n_runs 10 --gpu ${gpu}
done
done